<?php
if(!isset($create_student)){
	$student_field_options = array();
	foreach($students as $student){
		$student_field_options[$student->user_ID] = $student->f_name.' '.$student->l_name;
	}
}


$subscription_pack_options = array();
foreach($subscription_packs as $pack){
	$subscription_pack_options[$pack->subscription_pack_ID] = $pack->subscription_pack_name.' - Rs.'.$pack->subscription_amount;
}

?>
<br>
<div class="row">
	<div class="col-md-offset-2 col-md-6">
		<div class="panel panel-default">
			<div class="panel-heading">
				New Subscription
			</div>
			<div class="panel-body">
				<?php if(isset($create_student)) :  ?>
				<fieldset>
					<legend>Student:</legend>
					<div class="row">
						<div class="col-sm-3">
							<img src="<?= base_url('uploads/'.$create_student->profile_img); ?>" class="img-responsive img-thumbnail">
						</div>
						<div class="col-sm-9">
							<p><strong>Name : </strong> <?= $create_student->f_name.' '.$create_student->l_name; ?></p>
							<p><strong>Username : </strong> <?= $create_student->username; ?></p>
							<p><strong>E-mail : </strong> <?= $create_student->email; ?></p>
							<p><strong>Phone No. : </strong> <?= $create_student->phone_no; ?></p>
						</div>
					</div>
				</fieldset>
				<br><br>
				<?php endif; ?>
				<?= form_open('subscription/create'); ?>
				<?php 
				if(isset($create_student)){
					echo hidden_input(array('name'=>'student', 'value' => $create_student->user_ID));
				} else { 
					echo form_dropdown(array(
						'name'			=>'student',
						'label'			=>'Select Student :',
						'options'		=> $student_field_options,
						'class'			=> array('form-control'=>'select2'),
						'placeholder'	=> 'Select a Student'
					)); 
				}
				?>
				<?= form_dropdown(array(
					'name'			=>'subscription_pack',
					'label'			=>'Select Subscription Pack :',
					'options'		=> $subscription_pack_options,
					'class'			=> array('form-control'=>'select2'),
					'placeholder'	=> 'Select a Subscription Pack'
				)); ?>
				<?= form_submit(array('name'=>'create','value'=>'Create')); ?>
				<?= form_close(); ?>
			</div>
		</div>
	</div>
</div>
